//  AUTHOR: -
//    DATE: -
// VERSION: 0.1

// INITIALIZATION
echo( "---------------------------------" );
echo( "SCRIPT START" );
/* [CONSTRUCTION] */
// PART A
USE_PART_A = true;
// PART B
USE_PART_B = true;
// KEEP CAMERA
KEEP_CAMERA = true;
// QUALITY
RESOLUTION = 20; // [10:Shitty,20:Low,50:Medium,300:High,600:Perfect]


/* [PART A] */
// COLOR
part_a_color = "Fuchsia"; // [Fuchsia,DeepPink,Crimson,DarkOrange,Gold,Yellow,GreenYellow,DarkViolet,Aqua,SandyBrown,Wheat,Transparent]

/* [PART B] */
// COLOR
part_b_color = "GreenYellow"; // [Fuchsia,DeepPink,Crimson,DarkOrange,Gold,Yellow,GreenYellow,DarkViolet,Aqua,SandyBrown,Wheat,Transparent]

// USED TO STOP FOLLOWING VARS TO APPEAR IN CUSTOMIZER
module __Customizer_Limit__ () {}

// FUNCTIONS DEFINING DEFAULT CAMERA POSITION
function vp_r() = KEEP_CAMERA ? $vpr : [66.9, 0, 41.1];
function vp_t() = KEEP_CAMERA ? $vpt : [1.02286, 0.986865, 0.205507];
function vp_d() = KEEP_CAMERA ? $vpd : 74.4;
function vp_f() = KEEP_CAMERA ? $vpf : 22.5;

// DEFAULT VIEWPORT / CAMERA POSITION
$vpr = vp_r();
$vpt = vp_t();
$vpd = vp_d();
$vpf = vp_f();

// DEFAULT RENDER PARAMETERS
min_angle = 0.4;
min_size = 0.01;
num_fragments = 50;

// DEFINES THE MINIMUM ANGLE WE WILL BREAK IN ONE FRAGMENT
$fa = min_angle;
// DEFINES MINIMUM SIZE OF SOMETHINg TO BE RENDERED
$fs = min_size;
// DEFINES HOW MANY FRAGMENTS SHOULD BE USED TO RENDER
$fn = num_fragments;

// VERSION OF THE MODEL RELEASED
model_version = [0, 1, 0];
// VERSION OF THE OPENSCAD BINARY
openscad_version = version();
// TINY VALUE TO CORRECT SUBTRACTIONS
$corr = 0.005; // NEEDED TO FIX OPENSCAD FLICKERING ON DIFFS IN PREVIEW-RENDER

/**
* ADJUST PART SIZE DEPENDING ON COMBINATION
*/
function size_part_a( small_size, big_size ) = USE_PART_A ? ( USE_PART_B ? small_size : big_size ) : 0;

function size_part_b( small_size, big_size ) = USE_PART_B ? ( USE_PART_A ? small_size : big_size ) : 0;

/**
* ALLOWS USE OF ONE TRANSPARENT COLOR
*/
function recolor( color_name_original ) = color_name_original == "Transparent" ? [0.3,0.3,0.3,0.5] : color_name_original;

/**
* RENDERING PARAMETERS & VIEWPORT CONFIG
*/
module initialize() {
  echo( str("VPR: ",$vpr) ); // ROTATION ANGLES IN DEGREES
  echo( str("VPT: ",$vpt) ); // TRANSLATIONS IN UNITS
  echo( str("VPD: ",$vpd) ); // CAM DISTANCE IN UNITS
  echo( str("VPF: ",$vpf) ); // FIELD OF VIEW IN UNITS
}

/**
* CONSTRUCT PART A
*/
module part_a( color_name, radius ) {
  echo( "BUILDING PART A" );
  // VALIDATION CHECKS
  assert( radius >= 5, "Radius is too small for part A." );
  color( recolor(color_name) ) sphere( radius, $fn = RESOLUTION );
}

/**
* CONSTRUCT PART B
*/
module part_b( color_name, size ) {
  echo( "BUILDING PART B" );  
  assert( size >= 5, "Size is too small for part B." );
  color( recolor(color_name) ) cube( size, center = false, $fn = RESOLUTION );
}


/**
* MAIN MODULE TO CONSTRUCT CAP & GRIP
*/
module main() {
  assert( USE_PART_A || USE_PART_B, "No part chosen to build. Choose either A or B to be constructed." );
  if( USE_PART_A ) {
    part_a( part_a_color, size_part_a( 5 , 9 ) );
  }
  if( USE_PART_B ) {
    part_b( part_b_color, size_part_b( 7 , 9 ) );
  }
} // END MAIN MODULE

// INIT RENDER SYSTEM
echo( "INITIALIZING" );
initialize();

// EXECUTE PROGRAM
echo( "EXECUTING" );
main();
echo( "COMPLETE" );

echo( str( "MODEL VERSION: ", model_version[0],".",model_version[1],".",model_version[2] ) )
echo( str( "BINARY VERSION: ", openscad_version[0],".",openscad_version[1],".",openscad_version[2]) );
echo( "SCRIPT END" );
echo( "---------------------------------" );

/*
RELEASE HISTORY
0.1.0
* initial release

*/